#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"
#include "levels/castle_grounds/header.h"
extern u8 _castle_grounds_segment_ESegmentRomStart[]; 
extern u8 _castle_grounds_segment_ESegmentRomEnd[];
const LevelScript level_castle_grounds_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _castle_grounds_segment_7SegmentRomStart, _castle_grounds_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _castle_groundsSegmentRomStart, _castle_groundsSegmentRomEnd),
LOAD_RAW(0x0E, _castle_grounds_segment_ESegmentRomStart, _castle_grounds_segment_ESegmentRomEnd),
LOAD_MIO0(0xA,_water_skybox_mio0SegmentRomStart,_water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8,_common0_mio0SegmentRomStart,_common0_mio0SegmentRomEnd),
LOAD_RAW(15,_common0_geoSegmentRomStart,_common0_geoSegmentRomEnd),
LOAD_MIO0(5,_group10_mio0SegmentRomStart,_group10_mio0SegmentRomEnd),
LOAD_RAW(12,_group10_geoSegmentRomStart,_group10_geoSegmentRomEnd),
LOAD_MIO0(6,_group15_mio0SegmentRomStart,_group15_mio0SegmentRomEnd),
LOAD_RAW(13,_group15_geoSegmentRomStart,_group15_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_03,           castle_grounds_geo_0006F4),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_BUBBLY_TREE,  bubbly_tree_geo),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_WARP_PIPE,    warp_pipe_geo),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_CASTLE_DOOR,  castle_door_geo),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_METAL_DOOR,   metal_door_geo),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_VCUTM_GRILL,  castle_grounds_geo_00070C),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_FLAG,         castle_grounds_geo_000660),
    LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_CANNON_GRILL, castle_grounds_geo_000724),
LOAD_MODEL_FROM_GEO(22, warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23, bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24, spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25, snow_tree_geo),
LOAD_MODEL_FROM_GEO(27, palm_tree_geo),
LOAD_MODEL_FROM_GEO(31, metal_door_geo),
LOAD_MODEL_FROM_GEO(32, hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34, castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35, castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36, castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37, key_door_geo),
LOAD_MODEL_FROM_GEO(38, castle_door_geo),
LOAD_MODEL_FROM_GEO(41, metal_door_geo),
// LOAD_MODEL_FROM_DL(132,0x08025f08,4),
// LOAD_MODEL_FROM_DL(158,0x0302c8a0,4),
// LOAD_MODEL_FROM_DL(159,0x0302bcd0,4),
// LOAD_MODEL_FROM_DL(161,0x0301cb00,4),
// LOAD_MODEL_FROM_DL(164,0x04032a18,4),
// LOAD_MODEL_FROM_DL(201,0x080048e0,4),
// LOAD_MODEL_FROM_DL(218,0x08024bb8,4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_11),
JUMP_LINK(script_func_global_16),
JUMP_LINK(local_area_castle_grounds_1_),
FREE_LEVEL_POOL(),
MARIO_POS(1,180,-9,180,2460),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};
const LevelScript local_area_castle_grounds_1_[] = {
AREA(1,Geo_castle_grounds_1_0x13b9a00),
TERRAIN(col_castle_grounds_1_0xe03af10),
SET_BACKGROUND_MUSIC(0,0),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_castle_grounds_1_),
JUMP_LINK(local_warps_castle_grounds_1_),
END_AREA(),
RETURN()
};
const LevelScript local_objects_castle_grounds_1_[] = {
OBJECT_WITH_ACTS(0,11,1740,-11647,0,0,0,0xa0000, bhvSpinAirborneWarp,31),
OBJECT_WITH_ACTS(22,8245,90,-1136,0,0,0,0x1e0000, bhvWarpPipe,31),
OBJECT_WITH_ACTS(0,8228,150,-863,0,176,0,0x2d0000, bhvLaunchStarCollectWarp,31),
OBJECT_WITH_ACTS(187,-1523,1140,-8074,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(0,-2905,0,-164,0,0,0,0x0, bhvGoombaTripletSpawner,31),
OBJECT_WITH_ACTS(24,611,750,-5363,0,334,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(24,-606,750,-5512,0,38,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(24,3690,375,-1558,0,334,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(0,-2098,810,-4032,0,0,0,0x0, bhvBirdsSoundLoop,31),
OBJECT_WITH_ACTS(187,-1798,420,-1670,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,2183,420,-1847,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,-2251,1020,-5753,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,1228,1128,-7901,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(23,-1099,1128,-9303,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(187,3666,60,-558,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(0,3,450,-2188,0,180,0,0x0, bhvHardAirKnockBackWarp,31),
OBJECT_WITH_ACTS(0,8255,360,-664,0,182,0,0x2e0000, bhvPaintingDeathWarp,31),
OBJECT_WITH_ACTS(22,-3969,1620,-5082,0,335,0,0x1f0000, bhvWarpPipe,31),
OBJECT_WITH_ACTS(0,-3939,1800,-5037,0,336,0,0x2f0000, bhvLaunchStarCollectWarp,31),
OBJECT_WITH_ACTS(0,-3823,1890,-5495,0,336,0,0x300000, bhvPaintingDeathWarp,31),
OBJECT_WITH_ACTS(23,973,1128,-9295,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(22,7972,1128,-8523,0,0,0,0x200000, bhvWarpPipe,31),
OBJECT_WITH_ACTS(0,7975,1338,-8304,0,180,0,0x310000, bhvLaunchStarCollectWarp,31),
OBJECT_WITH_ACTS(0,8002,1530,-8343,0,180,0,0x320000, bhvPaintingDeathWarp,31),
OBJECT_WITH_ACTS(38,-72,1714,-12100,0,0,0,0x50000, bhvDoorWarp,31),
OBJECT_WITH_ACTS(187,1689,1128,-7853,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(0,39,1800,-11191,0,0,0,0x60000, bhvSwimmingWarp,31),
OBJECT_WITH_ACTS(84,3696,660,-1562,0,0,0,0x0, bhvBird,31),
OBJECT_WITH_ACTS(84,955,1470,-9352,0,0,0,0x0, bhvBird,31),
OBJECT_WITH_ACTS(84,-1115,1470,-9332,0,0,0,0x0, bhvBird,31),
OBJECT_WITH_ACTS(187,-2118,960,-5589,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,-1792,960,-5777,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,1511,870,-5395,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,2084,870,-5329,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,1894,870,-5503,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,2440,870,-4304,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,1601,870,-4184,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,6717,1128,-2515,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,9354,1128,-7185,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(187,9252,1128,-6838,0,0,0,0x0, bhvButterfly,31),
OBJECT_WITH_ACTS(23,8460,1328,-6008,0,308,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(23,8460,1328,-3597,0,244,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(38,80,1714,-12100,0,180,0,0x50000, bhvDoorWarp,31),
OBJECT_WITH_ACTS(116,159,1156,-2222,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,-20,1176,-2222,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,-186,1154,-2223,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,5341,1128,-6727,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,5602,1128,-6725,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,5615,1128,-6532,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,5353,1128,-6532,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(124,-391,0,-92,0,22,0,0xa70000, bhvMessagePanel,31),
RETURN()
};
const LevelScript local_warps_castle_grounds_1_[] = {
WARP_NODE(10,9,1,0,0),
WARP_NODE(30,9,1,10,0),
WARP_NODE(45,16,1,45,0),
WARP_NODE(46,16,1,46,0),
WARP_NODE(31,24,1,10,0),
WARP_NODE(47,16,1,47,0),
WARP_NODE(48,16,1,48,0),
WARP_NODE(32,12,1,10,0),
WARP_NODE(49,16,1,49,0),
WARP_NODE(50,16,1,50,0),
WARP_NODE(5,6,1,10,0),
WARP_NODE(0,16,1,10,0),
WARP_NODE(240,6,1,50,0),
WARP_NODE(241,6,1,50,0),
RETURN()
};
